package ru.yandex.analyzer;

import org.apache.lucene.analysis.TokenFilter;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.tokenattributes.CharTermAttribute;

import java.io.IOException;

public class ReplaceStringFilter extends TokenFilter {
    private final String from;
    private final String to;
    private final CharTermAttribute termAtt;

    public ReplaceStringFilter(final TokenStream in, final String from,
        final String to)
    {
        super(in);
        this.from = from;
        this.to = to;
        termAtt = addAttribute(CharTermAttribute.class);
    }

    @Override
    public final boolean incrementToken() throws IOException {
        if (input.incrementToken()) {
            String term = new String(termAtt.buffer(), 0, termAtt.length());
            String s = term.replace(from, to);
            if (s.isEmpty()) {
                return incrementToken();
            }
            if (!s.equals(term)) {
                termAtt.setEmpty();
                termAtt.append(s);
            }
            return true;
        } else {
            return false;
        }
    }
}
