package ru.yandex.analyzer;

import java.io.IOException;

import org.apache.lucene.analysis.TokenFilter;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.tokenattributes.CharTermAttribute;

public class SetFilter extends TokenFilter {
    private final CharTermAttribute termAtt;

    public SetFilter(final TokenStream in) {
        super(in);
        termAtt = addAttribute(CharTermAttribute.class);
    }

    @Override
    public final boolean incrementToken() throws IOException {
        if (input.incrementToken()) {
            StringBuilder sb = new StringBuilder(termAtt.length());
            boolean valueState = false;
            for (int i = 0; i < termAtt.length(); i++) {
                char c = termAtt.buffer()[i];
                if (c == '\t') {
                    valueState = true;
                } else if (!valueState || c == '\n') {
                    valueState = false;
                    sb.append(c);
                }
            }

            termAtt.setEmpty();
            termAtt.append(sb.toString());
            return true;
        } else {
            return false;
        }
    }
}
