package ru.yandex.analyzer;

import java.io.Reader;

import org.apache.lucene.analysis.KeywordTokenizer;
import org.apache.lucene.analysis.LetterTokenizer;
import org.apache.lucene.analysis.Tokenizer;
import org.apache.lucene.analysis.WhitespaceTokenizer;

public enum TokenizerType {
    WHITESPACE {
        public Tokenizer createTokenizer(Reader reader) {
            return new WhitespaceTokenizer(reader);
        }
    },
    LETTER {
        public Tokenizer createTokenizer(Reader reader) {
            return new LetterTokenizer(reader);
        }
    },
    KEYWORD {
        public Tokenizer createTokenizer(Reader reader) {
            return new KeywordTokenizer(reader);
        }
    },
    LF {
        public Tokenizer createTokenizer(Reader reader) {
            return new LFTokenizer(reader);
        }
    },
    COMA {
        public Tokenizer createTokenizer(Reader reader) {
            return new ComaTokenizer(reader);
        }
    },
    BOOLEAN {
        public Tokenizer createTokenizer(Reader reader) {
            return new BooleanTokenizer(reader);
        }
    };
    abstract Tokenizer createTokenizer(Reader reader);
}

