package ru.yandex.analyzer;

import org.apache.lucene.analysis.TokenFilter;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.tokenattributes.CharTermAttribute;

import java.io.IOException;

/**
 * A {@link TokenFilter} that truncate tokens to the specified size.
 */
public final class TruncateFilter extends TokenFilter
{
    private Integer width;

    private CharTermAttribute termAtt;

    public TruncateFilter(TokenStream in, Integer width)
    {
        super(in);
        termAtt = addAttribute(CharTermAttribute.class);
        this.width = width;
    }

    @Override
    public final boolean incrementToken() throws IOException {
        if (input.incrementToken()) {
            if (termAtt.length() > width) {
                termAtt.setLength(width);
            }
            return true;
        } else {
            return false;
        }
    }
}
