package ru.yandex.analyzer;

import java.util.Locale;

import org.apache.lucene.analysis.TokenFilter;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.tokenattributes.CharTermAttribute;

import java.io.IOException;

public class UpperCaseFilter extends TokenFilter {
    private final CharTermAttribute termAtt;

    public UpperCaseFilter(final TokenStream in) {
        super(in);
        termAtt = addAttribute(CharTermAttribute.class);
    }

    @Override
    public boolean incrementToken() throws IOException {
        if (input.incrementToken()) {
            String term = new String(termAtt.buffer(), 0, termAtt.length());
            String upper = term.toUpperCase(Locale.ENGLISH);
            // This is not an error. String.toUpperCase() returns 'this' if
            // there is no charater to upper case
            if (upper != term) {
                termAtt.setEmpty();
                termAtt.append(upper);
            }
            return true;
        } else {
            return false;
        }
    }
}

