package ru.yandex.analyzer.preprocessor;

import ru.yandex.function.GenericBiFunction;
import ru.yandex.util.string.StringUtils;

public enum DuplicationPolicy
    implements GenericBiFunction
        <String, String, String, FieldPreprocessorException>
{
    OVERWRITE {
        @Override
        public String apply(final String oldValue, final String newValue) {
            return newValue;
        }
    },
    CONCAT {
        @Override
        public String apply(final String oldValue, final String newValue) {
            return StringUtils.concat(oldValue, '\n', newValue);
        }
    },
    IGNORE {
        @Override
        public String apply(final String oldValue, final String newValue) {
            return oldValue;
        }
    },
    REPORT {
        @Override
        public String apply(final String oldValue, final String newValue)
            throws FieldPreprocessorException
        {
            throw new FieldPreprocessorException(
                "Duplication value. Old value <" + oldValue
                + ">, new value <" + newValue + '>');
        }
    };
}

