package ru.yandex.analyzer.preprocessor;

import ru.yandex.json.xpath.PathMatcher;
import ru.yandex.parser.config.ConfigException;
import ru.yandex.parser.config.IniConfig;

public enum FieldPreprocessorType {
    IDENTITY {
        @Override
        public FieldPreprocessor createPreprocessor(final IniConfig config) {
            return IdentityFieldPreprocessor.INSTANCE;
        }
    },
    JSON_SELECTOR {
        @Override
        public FieldPreprocessor createPreprocessor(final IniConfig config)
            throws ConfigException
        {
            PathMatcher selector = config.get("selector", PathMatcher::parse);
            DuplicationPolicy onDuplicate =
                config.getEnum(DuplicationPolicy.class, "on_duplicate");
            return new JsonSelectorPreprocessor(selector, onDuplicate);
        }
    };

    public abstract FieldPreprocessor createPreprocessor(
        final IniConfig config)
        throws ConfigException;
}

