package ru.yandex.lympho;

import java.io.IOException;
import java.util.LinkedHashSet;
import java.util.Set;

import org.apache.lucene.search.Query;
import org.apache.lucene.util.StringHelper;

import ru.yandex.logger.PrefixedLogger;
import ru.yandex.msearch.Index;
import ru.yandex.msearch.SearchRequestBase;
import ru.yandex.msearch.Searcher;
import ru.yandex.msearch.collector.CollectorFactory;
import ru.yandex.msearch.collector.DocCollector;
import ru.yandex.msearch.collector.PassThruCollectorFactory;
import ru.yandex.search.NullScorerFactory;
import ru.yandex.search.YandexScorerFactory;
import ru.yandex.search.prefix.Prefix;

public class BasicLymphoContext extends AbstractLymphoContext implements LymphoContext {
    private final Searcher searcher;

    private final YandexScorerFactory scorerFactory;
    private final CollectorFactory collectorFactory;
    private final AliveStatusProvier task;
    private final int shard;
    private final PrefixedLogger logger;

    public BasicLymphoContext(
        final Index index,
        final LymphoWorkerTask task)
        throws IOException
    {
        this(index, task.shard(), task.logger(), task);
    }

    public BasicLymphoContext(
        final Index index,
        final int shard,
        final PrefixedLogger logger,
        final AliveStatusProvier task)
        throws IOException
    {
        super(index);
        this.shard = shard;
        this.task = task;
        this.searcher = index.getSearcher(
            shard,
            index.config().syncSearcherDefault());
        this.chain.add(() -> searcher.close());

        this.scorerFactory = new NullScorerFactory(index.config());
        this.collectorFactory = new PassThruCollectorFactory();
        this.logger = logger;
    }

    public Searcher searcher() {
        return searcher;
    }

    public void search(
        final String prefixStr,
        final String queryText,
        final String get,
        final int limit,
        final LymphoSearchCollector collector)
        throws Exception
    {
        Prefix prefix = index.config().prefixParser().parse(prefixStr);
        Query query = parseQuery(queryText, prefix.toStringFast());
        String[] fieldsArray = get.split(",");
        Set<String> getFields = new LinkedHashSet<>(fieldsArray.length);
        for (String field: fieldsArray) {
            getFields.add(StringHelper.intern(field));
        }

        LymphoSearchRequest searchRequest =
            new LymphoSearchRequest(this, index, index.config());
        searchRequest.setGetFields(getFields);
        searchRequest.setScorerFactory(scorerFactory);

        collector.setCheckAlive(task);
        DocCollector col =
            collectorFactory.createCollector(searchRequest, collector);

        col.setPrefix(prefix);
        searcher.searcher().search(query, col, true);
        col.flush();
        col.close();
    }

    @Override
    public void close() throws IOException {
        chain.close();
    }

    @Override
    public void checkAbort() throws IOException {

    }

    @Override
    public PrefixedLogger logger() {
        return logger;
    }

    private final class MrSearchRequest extends SearchRequestBase {
        private MrSearchRequest(final Set<String> getFields) {
            super(
                BasicLymphoContext.this,
                BasicLymphoContext.this.index,
                BasicLymphoContext.this.index.config());

            this.getFields = getFields;
        }
    }
}
