package ru.yandex.lympho;

import java.io.IOException;

import org.apache.http.HttpEntity;
import org.apache.http.HttpEntityEnclosingRequest;
import org.apache.http.HttpException;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.protocol.HttpContext;
import org.apache.http.protocol.HttpRequestHandler;

import ru.yandex.http.util.BadRequestException;
import ru.yandex.http.util.CharsetUtils;
import ru.yandex.json.dom.JsonObject;
import ru.yandex.json.dom.TypesafeValueContentHandler;

public class LymphoAddTaskHandler implements HttpRequestHandler {
    private final LymphoNodeService service;

    public LymphoAddTaskHandler(LymphoNodeService service) {
        this.service = service;
    }

    @Override
    public void handle(
        final HttpRequest request,
        final HttpResponse response,
        final HttpContext context)
        throws HttpException, IOException
    {
        if (!(request instanceof HttpEntityEnclosingRequest)) {
            throw new BadRequestException("Expected post reqest with body");
        }

        HttpEntity entity = ((HttpEntityEnclosingRequest) request).getEntity();
        TaskConfigBuilder taskConfig;
        try {
            JsonObject jo = TypesafeValueContentHandler.parse(CharsetUtils.content(entity));
            taskConfig = new WorkerTaskConfig(jo.asMap(), service.indexConfig());
            service.saveTask(taskConfig);
        } catch (Exception je) {

        }
    }
}
