package ru.yandex.lympho;

import java.io.ByteArrayOutputStream;
import java.io.IOException;

import ru.yandex.io.NullWriter;
import ru.yandex.json.writer.JsonType;
import ru.yandex.json.writer.JsonValue;
import ru.yandex.json.writer.JsonWriter;
import ru.yandex.json.writer.JsonWriterBase;

public class LymphoJsonWriter extends JsonWriter {
    protected final JsonWriterBase wrapped;
    protected final ByteArrayOutputStream baos;
    protected int level = 1;

    public LymphoJsonWriter(
        final JsonType jsonType,
        final int buffer)
    {
        super(NullWriter.INSTANCE);
        this.baos = new ByteArrayOutputStream(buffer);
        this.wrapped = jsonType.create(baos);
    }

    @Override
    public void reset() {
        throw new UnsupportedOperationException("Reset is not supported by this writer");
    }

    @Override
    public void startObject() throws IOException {
        wrapped.startObject();
        level += 1;
    }

    @Override
    public void endObject() throws IOException {
        wrapped.endObject();
        level -= 1;
    }

    @Override
    public void startArray() throws IOException {
        wrapped.startArray();
        level += 1;
    }

    @Override
    public void endArray() throws IOException {
        wrapped.endArray();
        level -= 1;
    }

    @Override
    public void startString() throws IOException {
        wrapped.startString();
    }

    @Override
    public void endString() throws IOException {
        wrapped.endString();
    }

    @Override
    public void key(final String key) throws IOException {
        wrapped.key(key);
    }

    @Override
    public void key(final StringBuilder key) throws IOException {
        wrapped.key(key);
    }

    @Override
    public void nullValue() throws IOException {
        wrapped.nullValue();
    }

    @Override
    public void jsonValue(final String value) throws IOException {
        wrapped.jsonValue(value);
    }

    @Override
    public void value(final String value) throws IOException {
        wrapped.value(value);
    }

    @Override
    public void value(final StringBuilder value) throws IOException {
        wrapped.value(value);
    }

    @Override
    public void value(final Number value) throws IOException {
        wrapped.value(value);
    }

    @Override
    public void value(final float value, final boolean asString) throws IOException {
        wrapped.value(value, asString);
    }

    @Override
    public void value(final double value, final boolean asString) throws IOException {
        wrapped.value(value, asString);
    }

    @Override
    public void value(final int value, final boolean asString) throws IOException {
        wrapped.value(value, asString);
    }

    @Override
    public void value(final long value, final boolean asString) throws IOException {
        wrapped.value(value, asString);
    }

    @Override
    public void value(final boolean value) throws IOException {
        wrapped.value(value);
    }

    @Override
    public void value(final Throwable value) throws IOException {
        wrapped.value(value);
    }

    @Override
    public void value(final JsonValue value) throws IOException {
        wrapped.value(value);
    }

    @Override
    public void value(final Object value) throws IOException {
        wrapped.value(value);
    }

    @Override
    public void close() throws IOException {
        wrapped.close();
    }

    @Override
    public void flush() throws IOException {
        wrapped.flush();
    }

    @Override
    public void write(final int i) throws IOException {
        wrapped.write(i);
    }

    @Override
    public void write(final char[] cbuf, final int off, final int len)
        throws IOException
    {
        wrapped.write(cbuf, off, len);
    }

    @Override
    public void write(final String str, final int off, final int len)
        throws IOException
    {
        wrapped.write(str, off, len);
    }
}
