package ru.yandex.lympho;

import org.apache.lucene.util.BytesRef;

public class LymphoTerm {
    public String term;
    public int freq;
    public int totalFreq;

    public LymphoTerm() {
    }

    public void reset() {
        term = null;
        freq = -1;
        totalFreq = -1;
    }

    public void term(final BytesRef term) {
        this.term = term.utf8ToString();
    }


    public void freq(final int freq) {
        this.freq(freq, -1);
    }

    public void freq(final int freq, final int totalFreq) {
        this.freq = freq;
        this.totalFreq = totalFreq;
    }

    public String term() {
        return term;
    }

    public int freq() {
        return freq;
    }

    public int totalFreq() {
        return totalFreq;
    }

    @Override
    public String toString() {
        return "LymphoTerm{" +
                   "term='" + term + '\'' +
                   ", freq=" + freq +
                   ", totalFreq=" + totalFreq +
                   '}';
    }
}
