package ru.yandex.lympho;

import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;

import ru.yandex.logger.PrefixedLogger;

public class LymphoWorkerTask implements AliveStatusProvier {
    private final TaskConfig config;
    private final int shard;
    private final AtomicReference<LymphoWorkerTaskStatus> status = new AtomicReference<>(LymphoWorkerTaskStatus.PENDING);
    private final AtomicBoolean cancelled = new AtomicBoolean(false);
    private final PrefixedLogger logger;

    public LymphoWorkerTask(
        final TaskConfig config,
        final PrefixedLogger logger,
        final int shard)
    {
        this.config = config;
        this.shard = shard;
        this.logger = logger.addPrefix(config.taskId() + "_" + shard);
    }

    public LymphoWorkerTaskStatus status() {
        return status.get();
    }

    public void status(final LymphoWorkerTaskStatus status) {
        this.status.set(status);
    }

    public TaskConfig config() {
        return config;
    }

    public int shard() {
        return shard;
    }

    public boolean cancelled() {
        return cancelled.get();
    }

    public void cancel() {
        cancelled.set(true);
    }

    @Override
    public boolean isAlive() {
        return !cancelled.get();
    }

    public PrefixedLogger logger() {
        return logger;
    }
}
