package ru.yandex.lympho;

import java.io.IOException;
import java.net.URISyntaxException;

import ru.yandex.json.writer.JsonWriterBase;
import ru.yandex.msearch.Index;

public class OfflineLymphoContext extends BasicLymphoContext {
    private final LymphoWorkerTask task;

    public OfflineLymphoContext(
        final Index index,
        final LymphoWorkerTask task)
        throws IOException
    {
        super(index, task);

        this.task = task;
    }

    public JsonWriterBase httpOut(final String uri, final int batchSize)
        throws URISyntaxException
    {
        HttpOutput output = new HttpOutput(task, uri, batchSize);
        chain.add(output);
        return output;
    }
}
