package ru.yandex.lympho;

import java.io.IOException;
import java.net.URISyntaxException;
import java.util.logging.Logger;

public class OnlineHttpOutput extends AbstractHttpOutput {
    private final Logger logger;

    public OnlineHttpOutput(
            final Logger logger,
            final String uri,
            final int batchSize)
            throws URISyntaxException
    {
        super(uri, batchSize);

        this.logger = logger;
    }

    @Override
    public Logger logger() {
        return logger;
    }

    protected void writeBeforeBatch() throws IOException {
        wrapped.startObject();
        wrapped.key("records");
        wrapped.startArray();
    }

    protected void writeAfterBatch() throws IOException {
        wrapped.endArray();

        wrapped.key("meta");
        wrapped.startObject();
        wrapped.key("records_processed");
        wrapped.value(totalRecords);
        wrapped.key("batch_num");
        wrapped.value(batchNum);
        wrapped.endObject();
        wrapped.endObject();
    }
}
