package ru.yandex.lympho;

import java.io.IOException;
import java.net.URISyntaxException;

import org.apache.http.protocol.HttpContext;

import ru.yandex.json.writer.JsonWriterBase;
import ru.yandex.logger.PrefixedLogger;
import ru.yandex.msearch.HttpRequestContext;
import ru.yandex.msearch.Index;
import ru.yandex.msearch.NewSearchRequest;
import ru.yandex.msearch.SearchHandler;
import ru.yandex.msearch.collector.CollectorFactory;
import ru.yandex.msearch.collector.outergroup.OuterGroupFunctionFactory;
import ru.yandex.msearch.util.IOStater;
import ru.yandex.parser.uri.CgiParams;

public class OnlineLymphoContext
    extends AbstractLymphoContext
    implements LymphoContext, AliveStatusProvier
{
    protected final HttpContext httpContext;
    protected final HttpRequestContext requestContext;
    protected final OuterGroupFunctionFactory outerGroupFunctionFactory;
    protected final IOStater ioStater;
    protected final JsonWriterBase writer;

    public OnlineLymphoContext(
        final Index index,
        final HttpContext httpContext,
        final OuterGroupFunctionFactory outerGroupFunctionFactory,
        final IOStater ioStater,
        final JsonWriterBase writer)
    {
        super(index);

        this.httpContext = httpContext;
        this.requestContext = new HttpRequestContext(httpContext);
        this.ioStater = ioStater;
        this.outerGroupFunctionFactory = outerGroupFunctionFactory;
        this.writer = writer;
    }

    public JsonWriterBase out() {
        return writer;
    }

    public OnlineHttpOutput httpOut(final String uri, final int batchSize) throws URISyntaxException {
        OnlineHttpOutput output = new OnlineHttpOutput(requestContext.logger(), uri, batchSize);
        chain.add(output);
        return output;
    }

    public void search(
        final String query,
        final LymphoSearchCollector collector) throws Exception
    {
        search(query, Integer.MAX_VALUE, collector);
    }

    @Override
    public boolean isAlive() {
        try {
            requestContext.checkAbort();
        } catch (IOException ioe) {
            return false;
        }

        return true;
    }

    public void search(
        final String query,
        final int length,
        final LymphoSearchCollector collector) throws Exception
    {
        NewSearchRequest request =
            new NewSearchRequest(
                new CgiParams(query),
                httpContext,
                index,
                index.config(),
                outerGroupFunctionFactory);
        if (length < Integer.MAX_VALUE) {
            request.setLength(length);
        }

        CollectorFactory colFactory =
            CollectorFactory.factoryFromRequest(request);
        SearchHandler.SearchProcessor processor =
            new SearchHandler.SearchProcessor(index, request, colFactory, ioStater);

        collector.setCheckAlive(this);
        processor.process(collector);
    }

    @Override
    public void checkAbort() throws IOException {
    }

    @Override
    public PrefixedLogger logger() {
        return requestContext.logger();
    }
}
