package ru.yandex.msearch;

import ru.yandex.search.prefix.Prefix;

public interface AnalyzerProvider {
    PrefixingAnalyzerWrapper indexAnalyzer();

    PrefixingAnalyzerWrapper searchAnalyzer();

    default PrefixingAnalyzerWrapper indexAnalyzer(final Prefix prefix) {
        PrefixingAnalyzerWrapper analyzer = indexAnalyzer();
        analyzer.setPrefix(prefix.toString());
        return analyzer;
    }

    default PrefixingAnalyzerWrapper searchAnalyzer(final Prefix prefix) {
        PrefixingAnalyzerWrapper analyzer = searchAnalyzer();
        analyzer.setPrefix(prefix.toString());
        return analyzer;
    }
}

