package ru.yandex.msearch;

public class BadMessage implements Message {
    private final MessageContext context;
    private final String message;

    public BadMessage(final MessageContext context, final String message) {
        this.context = context;
        this.message = message;
    }

    @Override
    public void handle(MessageHandler handler) {
        context.logger().severe("BAD MESSAGE: " + message);
    }

    @Override
    public int priority() {
        return 0;
    }

    @Override
    public MessageContext context() {
        return context;
    }
}

