package ru.yandex.msearch;

import java.util.concurrent.PriorityBlockingQueue;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.TimeUnit;

public class BoundedPriorityBlockingQueue<E> extends PriorityBlockingQueue<E> {
    private int capacity;
    private ArrayBlockingQueue<Object> limiter;
    private Object fake;

    public BoundedPriorityBlockingQueue( int capacity )
    {
	super( capacity );
	limiter = new ArrayBlockingQueue<Object>( capacity );
	fake = new Object();
    }

    @Override
    public boolean offer(E o)
    {
	try
	{
	    limiter.put( new Object() );
	    super.offer( o );
	}
	catch( java.lang.InterruptedException e )
	{
	    return false;
	}
	return true;
    }

    @Override
    public boolean offer(E o, long timeout, TimeUnit unit)
    {
	try
	{
	    limiter.put( new Object() );
	    super.offer( o );
	}
	catch( java.lang.InterruptedException e )
	{
	    return false;
	}
	return true;
    }

    @Override
    public E poll()
    {
	E e = super.poll();
	limiter.poll();
	return e;
    }

    @Override
    public E poll( long timeout, TimeUnit unit ) throws java.lang.InterruptedException
    {
	E e = super.poll( timeout, unit );
	limiter.poll();
	return e;
    }

    @Override
    public boolean remove( Object o )
    {
	boolean removed = super.remove( o );
        limiter.poll();
	return removed;
    }

    @Override
    public E take() throws java.lang.InterruptedException
    {
	E e = super.take();
	limiter.poll();
	return e;
    }

    @Override
    public int remainingCapacity() {
	return limiter.remainingCapacity();
    }

}
