package ru.yandex.msearch;

import java.io.IOException;

import org.apache.lucene.search.IndexSearcher;

public class CloseableShardSearcher implements CloseableSearcher {
    private final Searcher searcher;
    private volatile boolean closed = false;

    public CloseableShardSearcher(final Searcher searcher) {
        this.searcher = searcher;
    }

    public IndexSearcher searcher() throws IOException {
        return searcher.searcher();
    }

    @Override
    public synchronized void close() throws IOException {
        if( closed )
        {
            System.err.println( "CloseableShardSearcher double close" );
            throw new RuntimeException( "CloseableShardSearcher double close" );
        }
        closed = true;
        searcher.free();
    }
}

