package ru.yandex.msearch;

import java.io.IOException;

import java.util.Map;
import java.util.concurrent.Future;

import ru.yandex.msearch.jobs.JobsManager;

public interface CommonTaskor {
    void flushShard(int shard) throws IOException;

    void reopenShardsReader(int shard, long readerGen);

    long maxSavedQueueId(final QueueShard shardId);

    Future pushQueueIds(Map<QueueShard, QueueId> ids, Shard from);

    void dirtifyQueueShard(QueueShard shard, long queueId);

    void clearDirtyQueueShard(QueueShard shard);

    long dirtyShardQueueId(QueueShard shard);

    JobsManager getJobsManager();

    void reopenMultiSearcherAsync(Shard shard);
}
