package ru.yandex.msearch;

import java.io.IOException;
import java.io.InputStream;

public class CopyingStream extends InputStream {
    private final InputStream in;
    private final byte[] b;
    private int off;

    public CopyingStream(InputStream in, byte[] b, int off) {
        this.in = in;
        this.b = b;
        this.off = off;
    }

    @Override
    public int available() throws IOException{
        return Math.min(b.length - off, in.available());
    }

    @Override
    public void close() throws IOException {
        in.close();
    }

    @Override
    public void mark(int readlimit) {
    }

    @Override
    public boolean markSupported() {
        return false;
    }

    @Override
    public int read() throws IOException {
        final int c = in.read();
        if (c != -1) {
            b[off++] = (byte)c;
        }
        return c;
    }

    @Override
    public int read(byte[] b) throws IOException {
        return read(b, 0, b.length);
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        final int read = in.read(b, off, Math.min(len, this.b.length - this.off));
        if (read > 0) {
            System.arraycopy(b, off, this.b, this.off, read);
            this.off += read;
        }
        return read;
    }

    @Override
    public void reset() throws IOException {
        throw new IOException("reset() is not supported");
    }

    @Override
    public long skip(long n) throws IOException {
        off += n;
        return in.skip(n);
    }
}

