package ru.yandex.msearch;

import java.nio.channels.WritableByteChannel;

import ru.yandex.search.prefix.Prefix;
import ru.yandex.search.prefix.LongPrefix;

public class DelayMessage implements JournalableMessage {
    private final MessageContext context;
    private final int delay;

    public DelayMessage(final MessageContext context, final int delay) {
        this.context = context;
        this.delay = delay;
    }

    @Override
    public void handle(final MessageHandler handler) {
        try {
            context.logger().info("Delaying for " + delay + " milliseconds");
            Thread.sleep(delay);
        } catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }

    @Override
    public void close() {
    }

    @Override
    public int priority() {
        return Message.Priority.ONLINE;
    }

    @Override
    public MessageContext context() {
        return context;
    }

    @Override
    public MessageQueueId queueId() {
        return MessageQueueId.MAGIC;
    }

    @Override
    public Prefix prefix() {
        return new LongPrefix(0);
    }

    @Override
    public QueueShard queueShard() {
        return QueueShard.EMPTY_SHARD_ID;
    }

    @Override
    public Type type() {
        return Type.JSON;
    }

    @Override
    public boolean journalable() {
        return false;
    }

    @Override
    public int writeTo(WritableByteChannel unused) {
        return 0;
    }
}

