package ru.yandex.msearch;

import java.io.IOException;

import java.nio.ByteBuffer;
import java.nio.channels.WritableByteChannel;
import java.nio.charset.StandardCharsets;

import java.text.ParseException;

import org.apache.http.NameValuePair;

import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.queryParser.QueryParser;
import org.apache.lucene.search.QueryProducer;
import org.apache.lucene.util.Version;

import ru.yandex.http.util.BadRequestException;
import ru.yandex.http.util.YandexHeaders;

import ru.yandex.parser.string.NonEmptyValidator;

import ru.yandex.parser.uri.CgiParams;
import ru.yandex.parser.uri.UriParser;

import ru.yandex.queryParser.YandexQueryParser;

import ru.yandex.search.prefix.Prefix;

public class DeleteByQueryNonJournalable implements DeleteMessage {
    private final Prefix prefix;
    private final QueryProducer query;
    private final MessageContext context;

    public DeleteByQueryNonJournalable(
        final MessageContext context,
        final Prefix prefix,
        final QueryProducer query)
    {
        this.context = context;
        this.prefix = prefix;
        this.query = query;
    }

    @Override
    public void close() {
    }

    @Override
    public void handle(final MessageHandler handler)
        throws IOException, ParseException
    {
        handler.delete(this);
    }

    @Override
    public Type type() {
        return Type.JSON;
    }

    @Override
    public Prefix prefix() {
        return prefix;
    }

    @Override
    public MessageQueueId queueId() {
        return MessageQueueId.MAGIC;
    }

    @Override
    public boolean journalable() {
        return false;
    }

    @Override
    public int writeTo(final WritableByteChannel channel) throws IOException {
        return 0;
    }

    @Override
    public QueryProducer query(final Analyzer analyzer) throws ParseException {
        return query;
    }

    @Override
    public int priority() {
        return Message.Priority.ONLINE;
    }

    @Override
    public MessageContext context() {
        return context;
    }

    @Override
    public QueueShard queueShard() {
        return new QueueShard(
            (int) (prefix().hash() % QueueShard.SHARDS_MAGIC));
    }
}

