package ru.yandex.msearch;

import java.io.Closeable;
import java.io.IOException;
import java.io.Writer;
import java.util.Map;
import java.util.Map.Entry;

import org.apache.http.HttpException;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.HttpStatus;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.EntityTemplate;
import org.apache.http.protocol.HttpContext;
import org.apache.http.protocol.HttpRequestHandler;

import ru.yandex.http.server.sync.ContentProducerWriter;
import ru.yandex.http.server.sync.ContentWriter;

import ru.yandex.http.util.CharsetUtils;
import ru.yandex.http.util.ServerException;

import ru.yandex.json.writer.JsonType;
import ru.yandex.json.writer.JsonTypeExtractor;
import ru.yandex.json.writer.JsonWriter;

import ru.yandex.parser.uri.CgiParams;

public class DropCachesHandler implements HttpRequestHandler {

    public DropCachesHandler() {
    }

    @Override
    public void handle(final HttpRequest request,
        final HttpResponse response,
        final HttpContext context)
        throws HttpException, IOException
    {
        final CgiParams params = new CgiParams(request);
        final boolean blockCache = params.getBoolean("block-cache", false);
        final boolean compressedCache =
            params.getBoolean("compressed-cache", false);
        final boolean all =
            params.getBoolean("all", !(blockCache || compressedCache));
        if (all || blockCache) {
            org.apache.lucene.store.BlockCompressedInputStreamBase.dropCache();
        }
        if (all || compressedCache) {
            org.apache.lucene.store.BlockCompressedInputStreamBase
                .dropCompressedCache();
        }
    }

    @Override
    public String toString() {
        return "Drops internal block cache";
    }
}

