package ru.yandex.msearch;

/* An example of a very simple, multi-threaded HTTP server.
 * Implementation notes are in WebServer.html, and also
 * as comments in the source code.
 */

import java.io.*;
import java.net.*;
import java.util.*;

import java.util.logging.Logger;

import ru.yandex.logger.PrefixedLogger;

import ru.yandex.msearch.collector.outergroup.OuterGroupFunctionFactory;

import ru.yandex.search.prefix.PrefixParser;

public class DumpServer implements HTTPConstants, Runnable {
    /* Where worker threads stand idle */
    private final Vector<DumpWorker> threads = new Vector<DumpWorker>();
    private final Vector<DumpWorker> threadsAll = new Vector<DumpWorker>();
    private final ServerSocket ss;
    private final PrefixedLogger logger;
    private final Logger accessLogger;
    private volatile boolean exit = false;

    public DumpServer(
        final DatabaseManager databaseManager,
        final Config config,
        final PrefixedLogger logger,
        final Logger accessLogger)
        throws IOException
    {
        this.logger = logger;
        this.accessLogger = accessLogger;
        /* start worker threads */
        for (int i = 0; i < config.dump().workers(); ++i) {
            DumpWorker w =
                new DumpWorker(
                    this,
                    databaseManager,
                    config,
                    logger,
                    accessLogger);
            (new Thread(w, "DumpWorker #"+i)).start();
            threads.addElement(w);
            threadsAll.addElement(w);
        }

        ss = new ServerSocket(config.dump().port(), 10000);
        (new Thread(this, "DumpAccepter")).start();

    }

    public int port() {
        return ss.getLocalPort();
    }

    public void close() throws IOException
    {
    DumpWorker w = null;
	exit = true;
	for( int i = 0; i < threadsAll.size(); i++ )
	{
    	    w = threadsAll.elementAt(i);
	    w.stop();
	}
        ss.close();
    }

    public void run()
    {
        try
	{
    	    while (!exit)
	    {
        	Socket s = ss.accept();
		long startTime = System.currentTimeMillis();
		if( exit ) break;

        	DumpWorker w = null;
        	synchronized (threads)
		{
		    if (threads.isEmpty())
		    {
			logger.severe(
			    "HTTP_SERVER: Queue is full. Dropping connection");
			s.close();
            	    } else {
                	w = threads.elementAt(0);
                	threads.removeElementAt(0);
                	w.setSocket(s, startTime);
            	    }
        	}
    	    }
	    ss.close();
	} catch( IOException ioe )
	{
	    ioe.printStackTrace();
	    return;
	}
    }

    public void freeWorker(final DumpWorker worker) {
        threads.addElement(worker);
    }

    public static class RequestContext implements ru.yandex.msearch.RequestContext {
        private Socket s;
        private InputStream is;
        private PrintStream ps;
        private String sessionId;
        private PrefixedLogger logger;

        public RequestContext(
            final Socket s,
            final InputStream is,
            final PrintStream ps,
            final String sessionId,
            final PrefixedLogger logger)
        {
            this.s = s;
            this.is = is;
            this.ps = ps;
            this.sessionId = sessionId;
            this.logger = logger;
        }

        public String sessionId() {
            return sessionId;
        }

        @Override
        public void checkAbort() throws IOException
        {
            if (!s.isConnected() || s.isClosed()) {
                logger.severe("Connection closed by client");
                throw new IOException("Connection closed by remote <requester> host. Aborting any processing.");
            }
            try
            {
                is.available();
                s.sendUrgentData( 0 );
            }
            catch( IOException e )
            {
                logger.severe("Connection closed by client");
                throw new IOException( "Connection closed by remote <requester> host. Aborting any processing. ");
            }
        }

        @Override
        public PrefixedLogger logger() {
            return logger;
        }
    }
}
