package ru.yandex.msearch;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.lang.management.GarbageCollectorMXBean;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryMXBean;
import java.lang.management.MemoryUsage;
import java.net.InetAddress;
import java.net.Socket;
import java.net.URLDecoder;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.logging.Level;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.Deflater;
import java.util.zip.DeflaterOutputStream;

import com.tecnick.htmlutils.htmlentities.HTMLEntities;
import org.apache.http.HttpConnectionMetrics;
import org.apache.http.HttpHeaders;
import org.apache.http.HttpInetConnection;
import org.apache.http.HttpStatus;
import org.apache.http.message.BasicHttpRequest;
import org.apache.http.protocol.HttpContext;
import org.apache.http.protocol.HttpCoreContext;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.DocsEnum;
import org.apache.lucene.index.Fields;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.MultiFields;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.Terms;
import org.apache.lucene.index.TermsEnum;
import org.apache.lucene.queryParser.ParseException;
import org.apache.lucene.queryParser.QueryParser;
import org.apache.lucene.search.BooleanClause.Occur;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.DocIdSet;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.search.MatchAllDocsQuery;
import org.apache.lucene.search.PhraseQuery;
import org.apache.lucene.search.PrefixQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.search.TermRangeQuery;
import org.apache.lucene.util.Bits;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.SortedVIntList;
import org.apache.lucene.util.Version;

import ru.yandex.concurrent.NamedThreadFactory;
import ru.yandex.http.util.SynchronizedHttpContext;
import ru.yandex.http.util.server.HttpServer;
import ru.yandex.http.util.server.HttpSessionInfo;
import ru.yandex.http.util.server.JsonStatsConsumer;
import ru.yandex.http.util.server.LoggingServerConnection;
import ru.yandex.json.writer.JsonType;
import ru.yandex.json.writer.JsonTypeExtractor;
import ru.yandex.json.writer.JsonWriter;
import ru.yandex.logger.BackendAccessLoggerConfigDefaults;
import ru.yandex.logger.PrefixedLogger;
import ru.yandex.logger.SearchProxyAccessLoggerConfigDefaults;
import ru.yandex.msearch.collector.DocCollector;
import ru.yandex.msearch.collector.MergeFunc;
import ru.yandex.msearch.collector.MergeFuncFactory;
import ru.yandex.msearch.collector.SortedCollector;
import ru.yandex.msearch.collector.YaDoc3;
import ru.yandex.msearch.collector.group.GroupFunc;
import ru.yandex.msearch.collector.group.GroupFuncFactory;
import ru.yandex.msearch.collector.outergroup.OuterGroupFunction;
import ru.yandex.msearch.collector.outergroup.OuterGroupFunctionFactory;
import ru.yandex.msearch.collector.outergroup.XURLSOuterDeduplicator;
import ru.yandex.msearch.collector.sort.SortFunc;
import ru.yandex.msearch.collector.sort.SortFuncFactory;
import ru.yandex.msearch.jobs.IndexCopyJob;
import ru.yandex.msearch.jobs.Job;
import ru.yandex.msearch.util.Compress;
import ru.yandex.parser.string.BooleanParser;
import ru.yandex.queryParser.MultiFieldQueryParser;
import ru.yandex.queryParser.YandexQueryParser;
import ru.yandex.queryParser.YandexQueryParserFactory;
import ru.yandex.search.prefix.Prefix;
import ru.yandex.search.prefix.PrefixParser;
import ru.yandex.stater.RequestInfo;
import ru.yandex.stater.RequestsStater;
import ru.yandex.stater.StatsConsumer;
import ru.yandex.util.timesource.TimeSource;

public class DumpWorker implements HTTPConstants, Runnable {

    private static final int MAX_PARALLEL_PREFIX_SEARCH = 300;
    private static final int BUF_SIZE = 2048;
    private static final byte[] EOL = {(byte)'\r', (byte)'\n' };
    private static final ThreadPoolExecutor multiPrefixExecutor = new ThreadPoolExecutor( 
                                                                        MAX_PARALLEL_PREFIX_SEARCH, 
                                                                        MAX_PARALLEL_PREFIX_SEARCH, 
                                                                        1, 
                                                                        TimeUnit.MINUTES,
                                                                        new ArrayBlockingQueue<Runnable>(MAX_PARALLEL_PREFIX_SEARCH),
                                                                        new NamedThreadFactory("MultiPrefix-"),
                                                                        new ThreadPoolExecutor.CallerRunsPolicy() );

    /* buffer to use for requests */
    private final byte[] buf = new byte[BUF_SIZE];
    /* Socket to client we're handling */
    private final DumpServer server;
    private final DatabaseManager databaseManager;
    private final Config config;
    private volatile boolean exit = false;
    private long startTime = 0L;
    private Socket s;
    private String requestType;
    private String requestString;
    private String requestVersion;
    private HashMap<String, String> httpHeaders;
    private HashMap<String, String> requestParams;
    private DumpServer.RequestContext ctx;
    private final RequestsStater stater;
    private final PrefixedLogger logger;
    private final Logger accessLogger;

    public DumpWorker(
        final DumpServer server,
        final DatabaseManager databaseManager,
        final Config config,
        final PrefixedLogger logger,
        final Logger accessLogger)
    {
        this.server = server;
        this.databaseManager = databaseManager;
        this.config = config;
        this.logger = logger;
        this.accessLogger = accessLogger;
        stater = config.oldRequestsStater();
        s = null;
    }

    synchronized void setSocket(Socket s, long startTime)
    {
        this.s = s;
	this.startTime = startTime;
        notify();
    }

    public synchronized void run()
    {
        Compress.setThreadPriority(Thread.MIN_PRIORITY, true);
        while(!exit) {
            if (s == null) {
                /* nothing to do */
                try {
                    wait();
                } catch (InterruptedException e) {
                    /* should not happen */
                    continue;
                }
		continue;
            }
	   try
	   {
            try {
                handleClient();
            } catch (Exception e) {
                e.printStackTrace();
            }
	   }
	   catch( java.lang.OutOfMemoryError error )
	   {
//	    ireader.getSearcher().searchEnd();
	   }
            /* go back in wait queue if there's fewer
             * than numHandler connections.
             */
            s = null;
	    server.freeWorker( this );
        }
    }

    synchronized void stop()
    {
	exit = true;
	notify();
    }

    private void parseRequestString( String request ) throws IOException
    {
        String[] cols = request.split( "&" );
        for( int i = 0; i < cols.length; i++ )
        {
    	    int colon;
            String name, value;
            colon = cols[i].indexOf( '=' );
            if( colon == -1 )
            {
	        name = cols[i];
	        value = null;
	    }
	    else
	    {
	        name = cols[i].substring( 0, colon );
	        value = URLDecoder.decode( cols[i].substring( colon + 1 ), "utf8" );
	    }
	    requestParams.put( name, value );
	}
    }

    private void parseHttpRequest( InputStream is, PrintStream os ) throws IOException
    {
	BufferedReader reader = new BufferedReader( new InputStreamReader( is ) );
	String line = reader.readLine();
	if( line == null ) throw new IOException( "Empty request" );
	int space1 = line.indexOf( ' ' );
	if( space1 == -1 ) throw new IOException( "invalid http request: " + line );
	requestType = line.substring( 0, space1 );
	int space2 = line.lastIndexOf( ' ' );
	if( space2 == -1 ) throw new IOException( "invalid http request (no http version tag found): " + line );
	requestVersion = line.substring( space2 + 1 );
	requestString = line.substring( space1 + 1, space2 );

	httpHeaders = new HashMap<String, String>();

	//now read headers until end
	while( true )
	{
	    line = reader.readLine();
	    if( line == null ) throw new IOException( "Error reading http request" );
	    if( line.trim().length() == 0 ) break;
	    String name, value;
	    int colon = line.indexOf( ':' );
	    if( colon == -1 )
	    {
		name = line.toLowerCase();;
		value = "";
	    }
	    else
	    {
		name = line.substring( 0, colon ).toLowerCase();
		value = line.substring( colon + 1 );
                for (int i = 0; i < value.length(); ++i) {
                    if (!Character.isWhitespace(value.charAt(i))) {
                        value = value.substring(i);
                        break;
                    }
                }
	    }
	    httpHeaders.put( name, value );
	}

	requestParams = new HashMap<>();

	if( requestType.equalsIgnoreCase("GET") )
	{
	    int colon = requestString.indexOf( '?' );
	    if( colon != -1 )
	    {
		parseRequestString( requestString.substring( colon + 1 ) );
	    }
	}
	else if( requestType.equalsIgnoreCase("POST") )
	{
	    String contentType = httpHeaders.get("content-type");
	    if( !contentType.equalsIgnoreCase("application/x-www-form-urlencoded") ) 
		throw new IOException( "Error parsing http request (only application/x-www-form-urlencoded content type is supported in POST, while recceived is: " + contentType + ")" );
	    while( true )
	    {
		line = reader.readLine();
		if( line == null ) break;
		parseRequestString( line );
	    }
	}
    }

    private double getDouble(final Map<String, String> params,
        final String name, final double defaultValue)
            throws NumberFormatException {
        String value = params.get(name);
        if (value != null) {
            return Double.parseDouble(value);
        } else {
            return defaultValue;
        }
    }

    private int getInt(final Map<String, String> params,
        final String name, final int defaultValue)
            throws NumberFormatException {
        String value = params.get(name);
        if (value != null) {
            return Integer.parseInt(value);
        } else {
            return defaultValue;
        }
    }

    private Integer
     getInt(final Map<String, String> params,
        final String name, final Integer defaultValue)
            throws NumberFormatException {
        String value = params.get(name);
        if (value != null) {
            return Integer.parseInt(value);
        } else {
            return defaultValue;
        }
    }

    private boolean getBoolean(final Map<String, String> params,
        final String name, final boolean defaultValue)
            throws Exception {
        String value = params.get(name);
        if (value != null) {
            return BooleanParser.INSTANCE.apply(value);
        } else {
            return defaultValue;
        }
    }

    private String getString(final Map<String, String> params,
        final String name, final String defaultValue)
            throws NumberFormatException {
        String value = params.get(name);
        if (value != null) {
            return value;
        } else {
            return defaultValue;
        }
    }

    void handleClient() throws Exception, IOException {
        InputStream is = new BufferedInputStream(s.getInputStream());
        OutputStream os = new BufferedOutputStream(s.getOutputStream());
        PrintStream ps = new PrintStream(os,false,"UTF-8");
        /* we will only block in read for this many milliseconds
         * before we fail with java.io.InterruptedIOException,
         * at which point we will abandon the connection.
         */
        int retval = 0;
	try
	{
	    parseHttpRequest( is, ps );

            String sessionId =
                Long.toHexString((long)(Math.random()*Long.MAX_VALUE));
            ctx = new DumpServer.RequestContext(
                s,
                is,
                ps,
                sessionId,
                logger.replacePrefix(sessionId));
    	    s.setSoTimeout(config.http().timeout());
    	    s.setTcpNoDelay(true);

            if (ctx.logger().isLoggable(Level.INFO)) {
                ctx.logger().info("FROM " + s.getInetAddress().getHostAddress()
                    + ": " + requestType + " " + requestString);
            }

	    retval = handleRequest( ctx, requestParams, ps, os, requestString, true, false );
	    ps.flush();
	    ps.close();
	} catch (Exception e) {
	    ctx.logger().log(Level.SEVERE, "", e);
	    retval = 500;
        } finally {
            try {
                RequestInfo info = new RequestInfo(
		    TimeSource.INSTANCE.currentTimeMillis(),
		    HttpStatus.SC_OK,
		    startTime,
		    startTime,
		    0L,
		    0L);
                if (ctx.logger().isLoggable(Level.INFO)) {
                    ctx.logger().info("Total execution time from request: "
                        + requestString + " : " + info.requestTime() + " : "
                        + retval);
                }
                HttpContext context = new SynchronizedHttpContext();
                HttpSessionInfo sessionInfo = new HttpSessionInfo(context);
                for (Map.Entry<String, String> header: httpHeaders.entrySet()) {
                    sessionInfo.put(
                        "http_"
                        + header.getKey().toLowerCase(Locale.ENGLISH)
                            .replace('-', '_'),
                        header.getValue());
                }
                if (retval == 500) {
                    sessionInfo.put(LoggingServerConnection.STATUS, "500");
                    sessionInfo.put(
                        SearchProxyAccessLoggerConfigDefaults.HITS_COUNT,
                        "0");
                } else {
                    sessionInfo.put(LoggingServerConnection.STATUS, "200");
                    sessionInfo.put(
                        SearchProxyAccessLoggerConfigDefaults.HITS_COUNT,
                        Integer.toString(retval));
                }
                sessionInfo.put(
                    LoggingServerConnection.REQUEST_TIME,
                    Long.toString(info.requestTime()));
                sessionInfo.put(
                    LoggingServerConnection.PROCESSING_TIME,
                    Long.toString(info.processingTime()));

                context.setAttribute(
                    HttpCoreContext.HTTP_CONNECTION,
                    new FakeInetConnection(s));
                context.setAttribute(
                    HttpCoreContext.HTTP_REQUEST,
                    new BasicHttpRequest(requestType, requestString));
                context.setAttribute(HttpServer.SESSION_ID, ctx.sessionId());

                accessLogger.log(Level.INFO, "", sessionInfo);
                stater.accept(info);
            } catch (Exception ign) {
                ctx.logger().log(Level.SEVERE, "", ign);
            }
            s.close();
            ctx = null;
            if( ps != null ) ps.close();
            if( os != null ) os.close();
            if( is != null ) is.close();
            httpHeaders = null;
            requestParams = null;
        }
    }

    private void copyIndex(Map<String, String> params, PrintStream ps) throws Exception {
        Index index = databaseManager.database(params);
        String from = params.get("from");
        String shards = params.get("shards");
        String threadsStr = params.get("threads");
        if (from == null) {
            ps.println("<from> parameter is not specified");
            return;
        }
        if (shards == null) {
            ps.println("<shards> parameter is not specified");
            return;
        }
        int threads = 1;
        if (threadsStr != null) {
            threads = Integer.parseInt(threadsStr);
        }
        int timeout = getInt(params, "timeout", 60 * 60);
        int retryCount = getInt(params, "retry-count", 5);

        String[] shardsParts = shards.split("-");
        if (shardsParts.length != 2) {
            ps.println("invalid <shards> parameter");
            return;
        }
        int startShard = Integer.parseInt(shardsParts[0]);
        int endShard = Integer.parseInt(shardsParts[1]);

        String[] urls = from.split(";");
        boolean lockIndex = getBoolean(params, "lock-index", true);
        String shardingFieldsStr =
            getString(params, "sharding-fields", "__prefix,suid");
        Set<String> shardingFields = new HashSet<String>();
        for (String f : shardingFieldsStr.split(",")) {
            shardingFields.add(f);
        }
        boolean checkDups = getBoolean(params, "check-dups", true);
        boolean replace = getBoolean(params, "replace", false);
        boolean disableIndexing = getBoolean(params, "disable-indexing", true);

        Job job = Job.createIndexCopyJob(index, startShard, endShard, urls, threads, timeout, retryCount,
            shardingFields, lockIndex, checkDups, replace, disableIndexing);
        if (job == null) {
            ps.println("can't create copy job");
        }
        if (params.containsKey("abort") || params.containsKey("remove")) {
            job = index.getJobsManager().getJob(job);
            if (job != null) {
                job.stop();
                index.getJobsManager().removeJob(job);
            } else {
                ps.println("Job does not exists");
            }
        } else if (params.containsKey("stop")) {
            job = index.getJobsManager().getJob(job);
            if (job != null) {
                job.stop();
            } else {
                ps.println("Job does not exists");
            }
        } else if (params.containsKey("update")) {
            job = index.getJobsManager().getJob(job);
            if (job != null) {
                job.stop();
            } else {
                ps.println("Job does not exists");
            }
        } else if (params.containsKey("status")) {
            job = index.getJobsManager().getJob(job);
            if (job == null) {
                ps.println("Job does not exists");
            }
        } else {
            IndexCopyJob newJob = (IndexCopyJob) job;
            job = index.getJobsManager().addJob(job);
            if (job != newJob) {
                job.update(newJob);
            }
            job.start();
        }
        if (job != null) {
            printHeaderHtml(ps, "copyIndex request");
            job.printStats(ps);
        }
    }

    private void removeShards(int start, int stop, Map<String, String> params, PrintStream ps) throws IOException {
        Index index = databaseManager.database(params);

        int threads = 1;
        String threadsStr = params.get("threads");
        if (threadsStr != null) {
            threads = Integer.parseInt(threadsStr);
        }
        String shardingFieldsStr =
            getString(params, "sharding-fields", "__prefix,suid");
        Set<String> shardingFields = new HashSet<String>();
        for (String f : shardingFieldsStr.split(",")) {
            shardingFields.add(f);
        }

        Job job = Job.createShardsRemoverJob(index, start, stop, threads, shardingFields);
        if (job == null) {
            ps.println("can't create copy job");
        }
        if (params.containsKey("abort") || params.containsKey("remove")) {
            job = index.getJobsManager().getJob(job);
            if (job != null) {
                job.stop();
                index.getJobsManager().removeJob(job);
            } else {
                ps.println("Job does not exists");
            }
        } else if (params.containsKey("stop")) {
            job = index.getJobsManager().getJob(job);
            if (job != null) {
                job.stop();
            } else {
                ps.println("Job does not exists");
            }
        } else if (params.containsKey("status")) {
            job = index.getJobsManager().getJob(job);
            if (job == null) {
                ps.println("Job does not exists");
            }
        } else {
            job = index.getJobsManager().addJob(job);
            job.start();
        }
        if (job != null) {
            printHeaderHtml(ps, "removerShards request");
            job.printStats(ps);
        }
    }

    int handleRequest(
        DumpServer.RequestContext ctx,
        Map<String, String> params,
        PrintStream ps,
        OutputStream os,
        String request,
        boolean digits,
        boolean wildcard) throws Exception, IOException
    {
        if (request.equals("/ping")) {
            printHeader(ps, request);
            ps.println("dumpong");
            return 0;
        }

        if (request.equals("/stat")) {
            JsonType jsonType =
                JsonTypeExtractor.HUMAN_READABLE
                    .extract(
                        getString(params, "json-type", null),
                        getBoolean(params, "hr", true));
            printHeader(ps, request);
            JsonWriter jsonWriter =
                jsonType.create(new OutputStreamWriter(ps));
            JsonStatsConsumer statsConsumer =
                new JsonStatsConsumer(jsonWriter);
            stater.stats(statsConsumer);
            statsConsumer.close();
            jsonWriter.close();
            return 0;
        }

        if (request.startsWith("/fakecopy")) {
            Index index = databaseManager.database(params);
            index.getJobsManager().fakeCopy(
                getInt(params, "start-shard", 0),
                getInt(params, "end-shard", 65534)
            );
            printHeader(ps, request);
            ps.println("ok");
            return 0;
        }

        if (params.containsKey("removeshards")) {
            String shardsStr = params.get("shards");
            if (shardsStr == null) {
                ps.println("no shards parameter specified");
                return 0;
            }
            String[] range = shardsStr.split("-");
            if (range.length != 2) {
                ps.println("invalid shards parameter");
                return 0;
            }

            int start = Integer.parseInt(range[0]);
            int stop = Integer.parseInt(range[1]);
            removeShards(start, stop, params, ps);
            return 0;
        }

        if (params.containsKey("copyindex")) {
            copyIndex(params, ps);
            return 0;
        }

        if (params.containsKey("listjobs")) {
            boolean json = getBoolean(params, "json", false);
            printHeader(ps, request);
            Index index = databaseManager.database(params);
            List<Job> jobs = index.getJobsManager().getJobs();
            for (Job job : jobs) {
                if (json) {
                    ps.println(job.jsonString());
                } else {
                    ps.println(job.toString());
                }
            }
            return 0;
        }

        if (params.containsKey("dumpindex")) {
            Index index = databaseManager.database(params);
            return HTTPWorker.parseDumpIndex(
                params,
                ps,
                os,
                index,
                ctx);
        }

        if (params.containsKey("optimize")) {
            Index index = databaseManager.database(params);
            int optimize = getInt(params, "optimize", 3);
            int parallel = getInt(params, "parallel", 3);
            int startShard = getInt(params, "start_shard", 0);
            int endShard = getInt(params, "end_shard", index.shardsCount() - 1);
            printHeader(ps, request);
            ps.println("Running optimize to " + optimize + " segments");
            ps.flush();
            index.optimize(optimize, ps, parallel, startShard, endShard);
            ps.println("Optimize finished");
            ps.flush();
            return 0;
        }

        if (params.containsKey("expunge")) {
            Index index = databaseManager.database(params);
            int parallel = getInt(params, "parallel", 3);
            Integer version = getInt(params, "setversion", null);
            Boolean all = getBoolean(params, "expunge_all", false);
            Boolean convert = getBoolean(params, "convert", false);
            int startShard = getInt(params, "start_shard", 0);
            int endShard = getInt(params, "end_shard", index.shardsCount() - 1);
            double minPct = getDouble(params, "min_pct", 0);

            printHeader(ps, request);
            ps.println("Running expunge in " + parallel +
                " threads setting version to: " + version);
            ps.flush();
            index.expunge(ps, parallel, version, all, convert, minPct, startShard, endShard);
            ps.println("expunge finished");
            ps.flush();
            return 0;
        }

        if (params.containsKey("gcstats") || request.startsWith("/gcstats")) {
            List<GarbageCollectorMXBean> gcms = ManagementFactory.getGarbageCollectorMXBeans();
            long totalCount = 0;
            long totalTime = 0;
            Iterator<GarbageCollectorMXBean> iter = gcms.iterator();
            while (iter.hasNext()) {
                GarbageCollectorMXBean gcm = iter.next();
                totalCount += gcm.getCollectionCount();
                totalTime += gcm.getCollectionTime();
            }
            MemoryMXBean mb = ManagementFactory.getMemoryMXBean();
            MemoryUsage mem = mb.getHeapMemoryUsage();
            printHeader(ps, request);
            ps.println("Collections: " + totalCount + "\nTime: " + totalTime);
            ps.println("Memory used: " + mem.getUsed() + "\nMemory commited: " + mem.getCommitted() + "\nMemory max: " + mem.getMax());
            ps.println("Finalization pending: " + mb.getObjectPendingFinalizationCount());
            return 0;
        }

        return 0;
    }

    boolean printHeaders(File targ, PrintStream ps) throws IOException {
        boolean ret = false;
        int rCode = 0;
        if (!targ.exists()) {
            rCode = HTTP_NOT_FOUND;
            ps.print("HTTP/1.0 " + HTTP_NOT_FOUND + " not found");
            ps.write(EOL);
            ret = false;
        }  else {
            rCode = HTTP_OK;
            ps.print("HTTP/1.0 " + HTTP_OK+" OK");
            ps.write(EOL);
            ret = true;
        }
//        log(new Date() + " From " +s.getInetAddress().getHostAddress()+": GET " +
//            targ.getAbsolutePath()+"-->"+rCode);
        ps.print("Server: Simple java");
        ps.write(EOL);
        ps.print("Date: " + (new Date()));
        ps.write(EOL);
        if (ret) {
            if (!targ.isDirectory()) {
                ps.print("Content-length: "+targ.length());
                ps.write(EOL);
                ps.print("Last Modified: " + (new
                              Date(targ.lastModified())));
                ps.write(EOL);
                String name = targ.getName();
                int ind = name.lastIndexOf('.');
                String ct = null;
                ct = "text/html";
                ps.print("Content-type: " + ct);
                ps.write(EOL);
            } else {
                ps.print("Content-type: text/html");
                ps.write(EOL);
            }
        }
        return ret;
    }

    void printHeader( PrintStream ps, String request ) throws IOException 
    {
	ps.print("HTTP/1.0 " + HTTP_OK+" OK");
	ps.write(EOL);
//        log((new Date()).toGMTString() + " From " +s.getInetAddress().getHostAddress()+": GET " + request + " --> Ok");
        ps.print("Server: Simple java");
        ps.write(EOL);
        ps.print("Date: " + (new Date()));
        ps.write(EOL);
        ps.print("Content-type: text/plain; charset=utf-8;");
        ps.write(EOL);
        ps.print("Connection: close");
        ps.write(EOL);
        ps.write(EOL);
    }

    void printHeaderHtml( PrintStream ps, String request ) throws IOException 
    {
	ps.print("HTTP/1.0 " + HTTP_OK+" OK");
	ps.write(EOL);
//        log((new Date()).toGMTString() + " From " +s.getInetAddress().getHostAddress()+": GET " + request + " --> Ok");
        ps.print("Server: Simple java");
        ps.write(EOL);
        ps.print("Date: " + (new Date()));
        ps.write(EOL);
        ps.print("Content-type: text/html; charset=utf-8;");
        ps.write(EOL);
        ps.print("Connection: close");
        ps.write(EOL);
        ps.write(EOL);
    }

    void send404( PrintStream ps ) throws IOException {
        ps.write(EOL);
        ps.write(EOL);
        ps.println("Not Found\n\n"+
                   "The requested resource was not found.\n");
    }

    void sendFile(File targ, PrintStream ps) throws IOException {
        InputStream is = null;
        ps.write(EOL);
        is = new FileInputStream(targ.getAbsolutePath());

        try {
            int n;
            while ((n = is.read(buf)) > 0) {
                ps.write(buf, 0, n);
            }
        } finally {
            is.close();
        }
    }

    private static class FakeInetConnection implements HttpInetConnection {
        private final Socket socket;

        public FakeInetConnection(final Socket socket) {
            this.socket = socket;
        }

        @Override
        public void close() {
        }

        @Override
        public boolean isOpen() {
            return true;
        }

        @Override
        public boolean isStale() {
            return false;
        }

        @Override
        public void setSocketTimeout(final int timeout) {
        }

        @Override
        public int getSocketTimeout() {
            return 0;
        }

        @Override
        public void shutdown() {
        }

        @Override
        public HttpConnectionMetrics getMetrics() {
            return null;
        }

        @Override
        public InetAddress getLocalAddress() {
            return socket.getLocalAddress();
        }

        @Override
        public int getLocalPort() {
            return socket.getLocalPort();
        }

        @Override
        public InetAddress getRemoteAddress() {
            return socket.getInetAddress();
        }

        @Override
        public int getRemotePort() {
            return socket.getPort();
        }
    }
}

