package ru.yandex.msearch;

import org.apache.lucene.index.CorruptIndexException;

public class DuplicatePrimaryKeyException extends CorruptIndexException {
    private final PrimaryKey primaryKey;

    public DuplicatePrimaryKeyException(final PrimaryKey primaryKey) {
        super("Too many docs found for key " + primaryKey);
        this.primaryKey = primaryKey;
    }

    public PrimaryKey primaryKey() {
        return primaryKey;
    }
}

