package ru.yandex.msearch;

import java.io.File;

import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FSDirectory;
import org.apache.lucene.store.IndexInput;
import org.apache.lucene.util.automaton.fst.*;

public class FSTTest {
    public static void main(final String[] args) throws Exception {
        final String fstFileName = args[0];
        final boolean backward = args.length > 1;
        final File fstFile = new File(fstFileName);
        final File baseDir = fstFile.getParentFile();
        final Directory dir = FSDirectory.open(baseDir);
        final IndexInput in = dir.openInput(fstFile.getName());
        final PositiveIntOutputs fstOutputs =
            PositiveIntOutputs.getSingleton(true);
        in.readInt(); //skip header
        final FST<Long> fst = new FST<Long>(in, fstOutputs);
        final BytesRefFSTEnum<Long> fstEnum = new BytesRefFSTEnum<Long>(fst);

        BytesRefFSTEnum.InputOutput<Long> current;
        if (backward) {
            while ((current = fstEnum.prev()) != null) {
                System.out.println("i: " + current.input.utf8ToString() + ", o: "
                    + current.output);
            }
        } else {
            while ((current = fstEnum.next()) != null) {
                System.out.println("i: " + current.input.utf8ToString() + ", o: "
                    + current.output);
            }
        }
    }
}
