package ru.yandex.msearch;

import java.io.IOException;

import java.nio.channels.WritableByteChannel;

import java.text.ParseException;

import ru.yandex.search.prefix.Prefix;

public class FilterJournalableMessage implements JournalableMessage {
    private final JournalableMessage message;

    public FilterJournalableMessage(final JournalableMessage message) {
        this.message = message;
    }

    @Override
    public void handle(final MessageHandler handler)
        throws IOException, ParseException
    {
        message.handle(handler);
    }

    @Override
    public void close() throws IOException {
        message.close();
    }

    @Override
    public int priority() {
        return message.priority();
    }

    @Override
    public MessageContext context() {
        return message.context();
    }

    @Override
    public Type type() {
        return message.type();
    }

    @Override
    public MessageQueueId queueId() {
        return message.queueId();
    }

    @Override
    public boolean journalable() {
        return message.journalable();
    }

    @Override
    public int writeTo(final WritableByteChannel channel) throws IOException {
        return message.writeTo(channel);
    }

    @Override
    public Prefix prefix() {
        return message.prefix();
    }

    @Override
    public QueueShard queueShard() {
        return message.queueShard();
    }
}

