package ru.yandex.msearch;

import java.io.IOException;

import org.apache.lucene.index.IndexReader;
import org.apache.lucene.search.IndexSearcher;

public abstract class FilterSearcher extends Searcher {
    protected final Searcher in;

    protected FilterSearcher(Searcher in) {
        this.in = in;
    }

    @Override
    public IndexSearcher searcher() throws IOException {
        return in.searcher();
    }

    @Override
    public IndexReader reader() throws IOException {
        return in.reader();
    }

    @Override
    public void free() throws IOException {
        in.free();
    }

    @Override
    public void close() throws IOException {
        in.close();
    }

    @Override
    public void incRef() {
        in.incRef();
    }

    @Override
    public int decRef() {
        return in.decRef();
    }

    @Override
    int refs() {
        return in.refs();
    }

    @Override
    public int numDocs() {
        return in.numDocs();
    }
}
