package ru.yandex.msearch;

import java.util.Set;

public class GetFieldsConfig {
    private final Set<String> fields;
    private final boolean skipNulls;
    private final boolean hasAsterisk;

    public GetFieldsConfig(
        final Set<String> fields,
        final boolean skipNulls,
        final boolean hasAsterisk)
    {
        this.fields = fields;
        this.skipNulls = skipNulls;
        this.hasAsterisk = hasAsterisk;
    }

    public Set<String> fields() {
        return fields;
    }

    public boolean isEmpty() {
        return fields.isEmpty();
    }

    public boolean skipNulls() {
        return skipNulls;
    }

    public boolean hasAsterisk() {
        return hasAsterisk;
    }
}

