package ru.yandex.msearch;

import java.io.IOException;

import java.util.logging.Level;
import java.util.logging.Logger;

import org.apache.http.protocol.HttpContext;
import org.apache.http.protocol.ExecutionContext;

import ru.yandex.http.server.sync.BaseHttpServer;
import ru.yandex.http.server.sync.LoggingHttpServerConnection;

import ru.yandex.io.TaggedIOException;

import ru.yandex.logger.PrefixedLogger;

import ru.yandex.util.timesource.TimeSource;

public class HttpRequestContext implements RequestContext {
    private static final long CHECK_ABORT_INTERVAL = 100;
    private final LoggingHttpServerConnection connection;
    private final PrefixedLogger logger;
    private long prevCheckAbort;

    public HttpRequestContext(final HttpContext context) {
        this(
            (LoggingHttpServerConnection) context.getAttribute(
                ExecutionContext.HTTP_CONNECTION),
            (PrefixedLogger) context.getAttribute(BaseHttpServer.LOGGER));
    }

    public HttpRequestContext(
        final LoggingHttpServerConnection connection,
        final PrefixedLogger logger)
    {
        this.connection = connection;
        this.logger = logger;
        prevCheckAbort = TimeSource.INSTANCE.currentTimeMillis();
    }

    public LoggingHttpServerConnection connection() {
        return connection;
    }

    @Override
    public PrefixedLogger logger() {
        return logger;
    }

    @Override
    public void checkAbort() throws IOException {
        if (TimeSource.INSTANCE.currentTimeMillis() - prevCheckAbort
            > CHECK_ABORT_INTERVAL)
        {
            prevCheckAbort = TimeSource.INSTANCE.currentTimeMillis();
            if (!connection.isOpen() || connection.isStale()) {
                throw new TaggedIOException(
                    connection.inputTag(),
                    new IOException("Request was cancelled"));
            }
        }
    }
}

