package ru.yandex.msearch;

import java.io.IOException;
import java.text.ParseException;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;

import java.util.logging.Logger;

import org.apache.lucene.index.codecs.CodecProvider;
import org.apache.lucene.search.QueryProducer;

import ru.yandex.logger.PrefixedLogger;

import ru.yandex.search.prefix.Prefix;

public interface IndexAccessor {
    public interface AtomicOp {
        void run() throws IOException;
    }

    public interface PrefixOp {
        void run() throws IOException, ParseException;
    }

    public PrefixedLogger logger();

    public Logger indexLogger();

    public void updateQueueIds(Map<QueueShard, QueueId> ids);
    public long queueId(QueueShard shard);

    CloseableSearcher searcher() throws IOException;

    void primaryKeyAtomicOp(PrimaryKey key, AtomicOp op) throws IOException;
    void prefixReadAtomicOp(Prefix prefix, PrefixOp op) throws IOException, ParseException;
    void prefixWriteAtomicOp(Prefix prefix, PrefixOp op) throws IOException, ParseException;

    void deleteDocuments(QueryProducer query) throws IOException;
    void dirtifyQueueShard(QueueShard shard, long queueId);
}
