package ru.yandex.msearch;

import java.io.IOException;
import java.text.ParseException;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;

import java.util.logging.Level;
import java.util.logging.Logger;

public class IndexDispatcher implements MessageDispatcher {
    private final Index index;
    private final boolean offline;
    private final Logger logger;

    public IndexDispatcher(
        final Index index,
        final boolean offline,
        final Logger logger)
    {
        this.logger = logger;
        this.index = index;
        this.offline = offline;
    }

    private void handleTask(Future<Void> f)
        throws IOException, ParseException
    {
        if (!offline) {
            try {
                f.get();
            } catch (CancellationException e) {
                // task will never be cancelled
                // with mayInterruptIfRunning == true
            } catch (InterruptedException e) {
            } catch (ExecutionException e) {
                Throwable cause = e.getCause();
                if (cause instanceof IOException) {
                    logger.log(
                        Level.SEVERE,
                        "IOException while handling message",
                        cause);
                    throw (IOException) cause;
                } else if (cause instanceof ParseException) {
                    logger.log(
                        Level.SEVERE,
                        "ParseException while handling message",
                        cause);
                    throw (ParseException) cause;
                } else {
                    logger.log(
                        Level.SEVERE,
                        "Exception while handling message",
                        cause);
                    throw new RuntimeException("Error occurred", cause);
                }
            }
        }
    }

    @Override
    public void dispatch(Message message) throws IOException, ParseException {
        if (message instanceof JournalableMessage) {
            handleTask(
                index.dispatch((JournalableMessage) message, false, true));
        } else {
            message.handle(index);
        }
    }
}

