package ru.yandex.msearch;

import java.io.IOException;

import ru.yandex.http.util.server.ImmutableBaseServerConfig;

class Indexer {
    private HttpIndexerServer jsonServer;

    public Indexer(
        final DatabaseManager dbManager,
        final Config config,
        final ImmutableBaseServerConfig serverConfig)
        throws IOException
    {
        jsonServer = new HttpIndexerServer(
            config,
            serverConfig,
            dbManager);
        jsonServer.start();
    }

    public void close() throws IOException {
        jsonServer.close();
    }

    public int jsonServerPort() throws IOException {
        return jsonServer.port();
    }

    public HttpIndexerServer server() {
        return jsonServer;
    }
}
