package ru.yandex.msearch;

import java.io.IOException;
import java.io.InputStream;

import java.nio.charset.Charset;

import java.text.ParseException;

import ru.yandex.msearch.config.DatabaseConfig;

public class JsonBatchDeleteMessage extends JsonMessage {
    public JsonBatchDeleteMessage(
        final MessageContext context,
        final byte[] dump,
        final Charset charset,
        final int priority,
        final QueueShard queueShard,
        final MessageQueueId queueId,
        final DatabaseConfig config,
        final boolean journalable,
        final boolean orderIndependentUpdate)
        throws IOException, ParseException
    {
        super(
            context,
            "/delete",
            dump,
            charset,
            priority,
            queueShard,
            queueId,
            config,
            journalable,
            orderIndependentUpdate);
    }

    @Override
    public void handle(final MessageHandler handler)
        throws IOException, ParseException
    {
        handler.delete(this);
    }
}

