package ru.yandex.msearch;

import java.io.IOException;
import java.nio.charset.Charset;
import java.text.ParseException;
import java.util.List;
import java.util.Map;

import ru.yandex.msearch.config.DatabaseConfig;
import ru.yandex.msearch.indexprocessor.IndexDocProcessor;
import ru.yandex.msearch.indexprocessor.IndexDocProcessorFactory;
import ru.yandex.search.json.MapCollector;
import ru.yandex.search.json.RootHandler;
import ru.yandex.search.json.fieldfunction.FieldFunction;
import ru.yandex.search.prefix.Prefix;

public abstract class JsonMessage
    extends AbstractJsonMessage
    implements DocumentsMessage
{
    private final Prefix prefix;
    private final HTMLDocument[] docs;
    private final Map<String,String> conditions;
    private final IndexDocProcessor indexDocProcessor;

    public JsonMessage(
        final MessageContext context,
        final String uri,
        final byte[] dump,
        final Charset charset,
        final int priority,
        final QueueShard queueShard,
        final MessageQueueId queueId,
        final DatabaseConfig config,
        final boolean journalable,
        final boolean orderIndependentUpdate)
        throws IOException, ParseException
    {
        super(
            context,
            uri,
            dump,
            charset,
            priority,
            queueShard,
            queueId,
            config,
            journalable);

        MapCollector collector = new MapCollector(config.indexPrefixParser());
        parse(dump, manager -> new RootHandler(manager, collector));
        prefix = collector.getPrefix();
        if (prefix == null) {
            throw new ParseException("prefix not set", 0);
        }
        conditions = collector.getConditions();
        List<Map<String, FieldFunction>> documents = collector.getDocuments();
        docs = new HTMLDocument[documents.size()];
        for (int i = 0; i < documents.size(); ++i) {
            docs[i] = new HTMLDocument(
                documents.get(i),
                prefix,
                queueId.phantomQueueId(),
                queueShard.service(),
                orderIndependentUpdate,
                config,
                context.logger());
        }

        this.indexDocProcessor =
            IndexDocProcessorFactory.INTSANCE.create(
                collector.docProcessor(),
                config,
                context.logger());
    }

    @Override
    public IndexDocProcessor docProcessor() {
        return indexDocProcessor;
    }

    @Override
    public void close() {
        if (docs != null) {
            for (HTMLDocument doc : docs) {
                doc.close();
            }
        }
    }

    @Override
    public Prefix prefix() {
        return prefix;
    }

    public Map<String, String> conditions() {
        return conditions;
    }

    @Override
    public HTMLDocument[] documents() {
        return docs;
    }
}

