package ru.yandex.msearch;

import java.io.IOException;
import java.io.InputStream;

import java.nio.charset.Charset;

import java.text.ParseException;

import ru.yandex.msearch.config.DatabaseConfig;

public class JsonModifyMessage extends JsonMessage {
    public JsonModifyMessage(
        final MessageContext context,
        final byte[] dump,
        final Charset charset,
        final int priority,
        final QueueShard queueShard,
        final MessageQueueId queueId,
        final DatabaseConfig config,
        final boolean journalable,
        final boolean orderIndependentUpdate)
        throws IOException, ParseException
    {
        super(
            context,
            "/modify",
            dump,
            charset,
            priority,
            queueShard,
            queueId,
            config,
            journalable,
            orderIndependentUpdate);
    }

    @Override
    public void handle(final MessageHandler handler)
        throws IOException, ParseException
    {
        handler.modify(this, conditions());
    }
}

