package ru.yandex.msearch;

import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;

import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.MultiReader;
import org.apache.lucene.search.IndexSearcher;

public class MemorySearcher extends Searcher.MultiSearcher {
    private HashMap<AbstractPart,Searcher> parts;

    public MemorySearcher(final Collection<AbstractPart> parts)
        throws IOException
    {
        super();
        initSubSearchers( initSearchers(parts) );
    }

    public MemorySearcher(final HashMap<AbstractPart,Searcher> parts)
        throws IOException
    {
        super();
        initSubSearchers( copySearchers(parts) );
    }

    private Searcher[] copySearchers( HashMap<AbstractPart,Searcher> parts )
    {
        this.parts = parts;
        Collection<Searcher> searchers = this.parts.values();
        for( Searcher searcher : searchers )
        {
            searcher.incRef();
        }
        return searchers.toArray( new Searcher[parts.size()] );
    }

    private Searcher[] initSearchers( Collection<AbstractPart> parts ) throws IOException
    {
        this.parts = new HashMap<AbstractPart,Searcher>();
        for( AbstractPart part : parts )
        {
            this.parts.put( part, part.getSearcher() );
        }
        return this.parts.values().toArray( new Searcher[parts.size()] );
    }

    public MemorySearcher removePart( AbstractPart part ) throws IOException
    {
        HashMap<AbstractPart,Searcher> newParts = new HashMap<AbstractPart,Searcher>(parts);
        if( newParts.remove( part ) == null )
        {
            throw new IOException( "Memory index consistency failed: can't remove part <" + part + "> from memoryIndex <" + parts.size() + ">: " + this );
        }
        else
        {
            part.logger().info(() -> "MemoryIndex removePart: " + part
                + ", memorIndex <" + parts.size() + ">: " + this);
        }
        return new MemorySearcher(newParts);
    }

}
