package ru.yandex.msearch;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;

import java.text.ParseException;

import java.util.logging.Logger;

import ru.yandex.msearch.config.DatabaseConfig;

public interface Message {
    public static class Priority {
        public static final int JOURNAL = 100500;
        public static final int ONLINE = 1050;
        public static final int OFFLINE = 15;
    }

    public enum Type {
        JSON {
            public MessageReader reader(
                final InputStream in,
                final int priority,
                final DatabaseConfig config,
                final Logger logger)
                throws EOFException, IOException, ParseException
            {
                return new JsonReader(in, priority, config, logger);
            }
        };
        public abstract MessageReader reader(
            final InputStream in,
            final int priority,
            final DatabaseConfig config,
            final Logger logger)
            throws EOFException, IOException, ParseException;
    }

    void handle(MessageHandler handler) throws IOException, ParseException;

    int priority();

    MessageContext context();
}

