package ru.yandex.msearch;

import java.io.IOException;
import java.text.ParseException;
import java.util.Map;
import java.util.Set;

import org.apache.lucene.search.Query;

import ru.yandex.collection.IntSet;
import ru.yandex.search.json.fieldfunction.ConditionsAccessor;

public interface MessageHandler {
    void add(DocumentsMessage message, Map<String,String> conditions) throws IOException, ParseException;
    void modify(DocumentsMessage message, Map<String,String> conditions) throws IOException, ParseException;
    void delete(DocumentsMessage message) throws IOException, ParseException;
    void delete(DeleteMessage message) throws IOException, ParseException;
    void update(DocumentsMessage message, Map<String,String> conditions, boolean addIfNotExists, boolean orderIndependentUpdate, Set<String> preserveFields) throws IOException, ParseException;
    void updateIfNotMatches(UpdateIfNotMatchesMessage message, Map<String,String> conditions, boolean addIfNotExists, boolean orderIndependentUpdate) throws IOException, ParseException;
    void update(UpdateMessage message, Map<String,String> conditions, boolean addIfNotExists, boolean orderIndependentUpdate) throws IOException, ParseException;
    void reopen() throws IOException;
    void reopen(IntSet shards, Boolean ro, boolean doWait) throws IOException;
    long journalMessage( JournalableMessage message ) throws IOException;
}
