package ru.yandex.msearch;

import ru.yandex.function.AbstractStringBuilderable;

public class MessageQueueId extends AbstractStringBuilderable {
    public static final MessageQueueId MAGIC =
        new MessageQueueId(
            QueueShard.MAGIC_QUEUEID,
            QueueShard.MAGIC_QUEUEID,
            false);

    // From ZooQueueId: ...
    private final long queueId;
    // From &zoo-queue-id=... with fallback to queueId
    private final long phantomQueueId;
    // weak == check but do not commit
    private final boolean weakCheck;

    public MessageQueueId(
        final long queueId,
        final long phantomQueueId,
        final boolean weakCheck)
    {
        this.queueId = queueId;
        this.phantomQueueId = phantomQueueId;
        this.weakCheck = weakCheck;
    }

    public long queueId() {
        return queueId;
    }

    public long phantomQueueId() {
        return phantomQueueId;
    }

    public boolean weakCheck() {
        return weakCheck;
    }

    public boolean magic() {
        return queueId == QueueShard.MAGIC_QUEUEID;
    }

    public boolean magicPhantom() {
        return phantomQueueId == QueueShard.MAGIC_QUEUEID;
    }

    @Override
    public void toStringBuilder(final StringBuilder sb) {
        sb.append("MessageQueueId(");
        sb.append(queueId);
        sb.append(',');
        sb.append(phantomQueueId);
        sb.append(',');
        sb.append(weakCheck);
        sb.append(')');
    }
}
