package ru.yandex.msearch;

import ru.yandex.unsafe.NativeMemory2;

import ru.yandex.util.unicode.UnicodeUtil;

public class NativeCacheKey {
    private static final NativeMemory2.NativeMemoryAllocator allocator =
        NativeMemory2.NativeMemoryAllocator.get("NativeCacheKey");
    private static final int HASHCODE_SIZE = 4;
    private static final int HASH_PRIME = 31;

    private NativeCacheKey() {
    }

    public static long allocate(final int size) {
        final long key = allocator.allocUnboxed(size + HASHCODE_SIZE);
        NativeMemory2.unboxedFill(key, (byte)0);
        return key + HASHCODE_SIZE;
    }

    public static long allocate(final byte[] data) {
        final long key = allocator.allocUnboxed(data.length + HASHCODE_SIZE);
        NativeMemory2.unboxedSetInt(key, 0);
        NativeMemory2.unboxedWrite(key + HASHCODE_SIZE, data);
        return key + HASHCODE_SIZE;
    }

    public static int hashCode(final long key) {
        int hashCode = NativeMemory2.unboxedGetInt(key - HASHCODE_SIZE);
        if (hashCode == 0) {
            final int size = NativeMemory2.unboxedSize(key - HASHCODE_SIZE)
                 - HASHCODE_SIZE;
            long pos = key;
            long end = key + size;
            for (; pos < end; pos++) {
                hashCode =
                    HASH_PRIME * hashCode + NativeMemory2.unboxedGetByte(pos);
            }
            NativeMemory2.unboxedSetInt(key - HASHCODE_SIZE, hashCode);
        }
        return hashCode;
    }

    public static boolean equals(final long key1, final long key2) {
        return NativeMemory2.unboxedEquals(key1 - HASHCODE_SIZE,
            key2 - HASHCODE_SIZE);
    }

    public static void free(final long key) {
        allocator.freeUnboxed(key - HASHCODE_SIZE);
    }

    public static int size(final long key) {
        return NativeMemory2.unboxedSize(key - HASHCODE_SIZE) + HASHCODE_SIZE;
    }
}
