package ru.yandex.msearch;

import java.io.IOException;
import java.util.Map;

import ru.yandex.msearch.config.DatabaseConfig;

public abstract class PartFactory {
    public abstract AbstractPart create(
        final AnalyzerProvider analyzerProvider,
        final IndexManager indexManager,
        final IndexAccessor indexAccessor,
        final Map<QueueShard, QueueId> prevQueueIds,
        final long version)
        throws IOException;

    public static PartFactory constructFactory(final DatabaseConfig config) {
        if (config.primaryKey() == null) {
            return new PartFactory() {
                @Override
                public AbstractPart create(
                    final AnalyzerProvider analyzerProvider,
                    final IndexManager indexManager,
                    final IndexAccessor indexAccessor,
                    final Map<QueueShard, QueueId> prevQueueIds,
                    final long version)
                    throws IOException
                {
                    return new SimplePart(
                        analyzerProvider,
                        indexManager,
                        indexAccessor,
                        prevQueueIds,
                        version,
                        config);
                }
            };
        } else {
            return new PartFactory() {
                @Override
                public AbstractPart create(
                    final AnalyzerProvider analyzerProvider,
                    final IndexManager indexManager,
                    final IndexAccessor indexAccessor,
                    final Map<QueueShard, QueueId> prevQueueIds,
                    final long version)
                    throws IOException
                {
                    if (config.primaryKeyPartCacheDocuments()) {
                        return new NativeKeysDocIdCachingPrimaryKeyPart(
                            analyzerProvider,
                            indexManager,
                            indexAccessor,
                            prevQueueIds,
                            version,
                            config);
                    } else {
//                        return new NativeKeysCachingPrimaryKeyPart(
                        return new KeysCachingPrimaryKeyPart(
//                        return new BloomPrimaryKeyPart(
                            analyzerProvider,
                            indexManager,
                            indexAccessor,
                            prevQueueIds,
                            version,
                            config);
                    }
                }
            };
        }
    }
}

