package ru.yandex.msearch;

import java.io.IOException;

import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.MultiReader;
import org.apache.lucene.search.IndexSearcher;

public class PartSearcher extends Searcher
{
    private AbstractPart parent;

    private PartSearcher()
    {
        super();
    }

    public PartSearcher( IndexSearcher s, IndexReader r, AbstractPart parent )
    {
        super( s, r );
        this.parent = parent;
    }

    final synchronized public void incRef()
    {
        parent.incRef();
        super.incRef();
    }

    final synchronized public int decRef()
    {
//        parent.free();
        return super.decRef();
    }

    @Override
    public void free() throws IOException
    {
        parent.freeSearcher( this );
    }


    @Override
    public String toString()
    {
        return "PartSearcher: refs = " + refs() + ", part = " + parent + ", part.isClosed = " + parent.isClosed();
    }
/*
    @Override
    public void finalize() {
        if (reader != null) {
            System.err.println("PartSearcher " + this + " has no references anymore but is has not been freed");
            try {
                if (searcher != null) {
                    searcher.close();
                }
            } catch (IOException e) {
                e.printStackTrace();
            }
            try {
                reader.close();
            } catch (IOException e) {
                e.printStackTrace();
            }
        }
    }
*/
}
