package ru.yandex.msearch;

import java.io.IOException;
import java.util.Map;

import org.apache.lucene.document.Document;

import ru.yandex.msearch.config.DatabaseConfig;

public abstract class PrimaryKeyPart extends AbstractPart {

    public PrimaryKeyPart(
        final AnalyzerProvider analyzerProvider,
        final IndexManager indexManager,
        final IndexAccessor indexAccessor,
        final Map<QueueShard, QueueId> queueIds,
        final long version,
        final DatabaseConfig config)
        throws IOException
    {
        super(
            analyzerProvider,
            indexManager,
            indexAccessor,
            queueIds,
            version,
            config);
    }

    public abstract boolean hasPrimaryKey(final PrimaryKey primaryKey,
        final PrimaryKeySearcher primaryKeySearcher)
        throws IOException;
    public abstract Document getDocumentByPrimaryKey(
        final PrimaryKey primaryKey)
        throws IOException;
    public abstract void removePrimaryKey(final PrimaryKey primaryKey);
    public abstract boolean deleteDocument(final PrimaryKey primaryKey)
        throws IOException;
}
