package ru.yandex.msearch;

import java.io.IOException;

import org.apache.lucene.document.Document;

public class PrimaryKeySearcher implements PartVisitor {
    private final PrimaryKey primaryKey;
    private PrimaryKeyPart part = null;
    private Document doc = null;

    public PrimaryKeySearcher(final PrimaryKey primaryKey) {
        this.primaryKey = primaryKey;
    }

    public PrimaryKeyPart part() {
        return part;
    }

    public Document doc() {
        return doc;
    }

    public void doc(final Document doc) {
        this.doc = doc;
    }

    @Override
    public void visit(final AbstractPart part) throws IOException {
        if (this.part == null && part instanceof PrimaryKeyPart) {
            PrimaryKeyPart primaryKeyPart = (PrimaryKeyPart) part;
            if (primaryKeyPart.hasPrimaryKey(primaryKey, this)) {
                this.part = primaryKeyPart;
            }
        }
    }
}
