package ru.yandex.msearch;

import java.io.IOException;

import org.apache.lucene.store.BufferedIndexOutput;
import org.apache.lucene.store.IndexOutput;
import org.apache.lucene.store.DataInput;

public class PrintStreamOutputStream extends BufferedIndexOutput {

  private PrintStreamFile file;
  private long position;

  public PrintStreamOutputStream(PrintStreamFile f) {
    file = f;
    position = 0;
  }

  @Override
  public void close() throws IOException {
    super.close();
    file.remoteClose();
  }

  @Override
  public void seek(long pos) throws IOException {
    super.seek(pos);
    setFileLength();
    file.remoteSeek( pos );
    position = pos;
  }

  @Override
  public long length() {
    return file.length;
  }
/*
  @Override
  public void writeByte(byte b) throws IOException {
    file.remoteWriteByte( b );
    position++;
  }
*/
/*
  @Override
  public void writeBytes(byte[] b, int offset, int len) throws IOException {
    file.remoteWriteBytes( b, offset, len );
    position += len;
  }
*/
  private void setFileLength() {
    if (position > file.length) {
      file.setLength(position);
    }
  }

  @Override
  public void flush() throws IOException {
    super.flush();
    file.setLastModified(System.currentTimeMillis());
    setFileLength();
    file.remoteFlush();
  }
/*
  @Override
  public long getFilePointer() {
    return position;
  }
*/
  @Override
  public void flushBuffer(byte[] b, int offset, int len) throws IOException {
    file.remoteWriteBytes( b, offset, len );
    position += len;
  }



  @Override
  public void copyBytes(DataInput input, long numBytes) throws IOException {

    assert numBytes >= 0: "numBytes=" + numBytes;
    byte[] buffer = new byte[1000];

    while (numBytes > 0) {
      int toCopy = 1000;
      if (numBytes < toCopy) {
        toCopy = (int) numBytes;
      }
      input.readBytes( buffer, 0, toCopy, false );
      writeBytes( buffer, 0, toCopy );
      numBytes -= toCopy;
    }
  }
}
