package ru.yandex.msearch;

import java.util.concurrent.atomic.AtomicLong;

public class QueueId extends AtomicLong {
    private boolean dirtyFlag;

    public QueueId(final long oldId) {
        super(oldId);
        dirtyFlag = false;
    }

    public QueueId(final QueueId oldId) {
        super(oldId.get());
        dirtyFlag = false;
    }

    public void setId(final long newId) {
        dirtyFlag = true;
        super.set(newId);
    }

    public boolean dirty() {
        return dirtyFlag;
    }

    public boolean magic() {
        return get() == QueueShard.MAGIC_QUEUEID;
    }

    @Override
    public String toString() {
        return Long.toString(get());
    }
}
