package ru.yandex.msearch;

import java.io.IOException;
import java.text.ParseException;

import org.apache.http.HttpStatus;

import ru.yandex.collection.IntSet;
import ru.yandex.http.util.BadRequestException;
import ru.yandex.parser.string.IntSetParser;
import ru.yandex.parser.uri.CgiParams;

public class ReopenMessage implements Message {
    private final IntSet shards;
    private final Boolean ro;
    private final int priority;
    private final boolean doWait;
    private final MessageContext context;

    public ReopenMessage(
        final MessageContext context,
        final CgiParams params,
        final int priority)
        throws ParseException
    {
        this.priority = priority;
        this.context = context;
        try {
            shards = params.get("shards", null, IntSetParser.INSTANCE);
            ro = ro(params);
            doWait = params.getBoolean("wait", false);
        } catch (BadRequestException e) {
            ParseException pe = new ParseException("Bad reopen request", 0);
            pe.initCause(e);
            throw pe;
        }
    }

    private Boolean ro(final CgiParams params)
        throws ParseException, BadRequestException
    {
        Boolean ro = params.getBoolean("ro", null);
        Boolean rw = params.getBoolean("rw", null);
        if (ro != null && rw != null && ro == rw) {
            throw new ParseException(
                "&ro and &rw flags are mutually exclusive", 0);
        } else if (ro == null && rw != null) {
            ro = !rw;
        }
        return ro;
    }

    @Override
    public void handle(MessageHandler handler) throws IOException {
        handler.reopen(shards, ro, doWait);
    }

    @Override
    public int priority() {
        return priority;
    }

    @Override
    public MessageContext context() {
        return context;
    }
}
